IF EXISTS ( SELECT * fROM INFORMATION_SCHEMA.TABLES
				WHERE
					TABLE_NAME ='V_PDV_VD_CUPONS_NAO_COMPARACAO')
BEGIN
	DROP VIEW  [dbo].[V_PDV_VD_CUPONS_NAO_COMPARACAO] 
END
GO
--SELECT * FROM V_PDV_VD_CUPONS_NAO_COMPARACAO WHERE CD_EMP =1 AND CD_FILIAL = 1 AND DT_VD = '2018-06-04' ORDER BY CD_CX,NR_ECF
CREATE VIEW V_PDV_VD_CUPONS_NAO_COMPARACAO AS
SELECT
	C.CD_EMP,
	C.CD_FILIAL,
	C.NR_ECF,
	C.CD_CX,
	C.DT_VD,
	C.VLR_LIQ_VD AS VLR_LIQ_VD_LOJA,
	V.VLR_TOT_CUPOM AS VLR_LIQ_VD_MTZ,
	C.VLR_LIQ_VD - ISNULL(V.VLR_TOT_CUPOM,0) AS VLR_DIF ,
	CASE WHEN C.ST_VD =1 THEN
		'CANCELADO'
	ELSE
		''
	END AS ST_VD_LOJA,
	CASE WHEN V.ST_CUPOM =1 THEN
		'CANCELADO'
	ELSE
		''
	END AS ST_VD_MTZ,
	CASE WHEN C.ST_VD <> ISNULL(V.ST_CUPOM,-1) THEN
		'SIM'
	ELSE
		''
	END AS ST_VD_DIF,
	C.DT_CAD,
	V.DT_CONSD,
	ISNULL(V.CD_CTR,0) AS CD_VD,
	HR_CUPOM DT_VD_HORA_VENDA,
	C.ST_VD AS ST_VD,
	cn.DS_TP_CUPOM_NAO_FISCAL as DS_TIPO_OPERACAO,
	TP_CUPOM_NAO_FISCAL as TIPO_OPERACAO,
	ISNULL(P.CD_CTR,0) AS CONSD_PEND,
	ISNULL(e.CD_CONTROLE,0) AS ERRO,
	ISNULL(E.LAUDO,'') AS LAUDO,
	COALESCE (NCC_RC_DEB.CD_CTR_NCC,NCC_CRED_PARC.CD_CTR_NCC,'') AS CD_CTR_NCC,
	C.NR_ECF_UUID
FROM
	PDV_VD_CUPONS C LEFT OUTER JOIN PDV_CUPOM_NAO_FISCAL V ON
	C.CD_EMP = V.CD_EMP AND
	C.CD_FILIAL = V.CD_FILIAL AND
	C.NR_ECF = V.NR_COO AND
	C.CD_CX = V.CD_CX AND
	C.DT_VD = V.DT_CUPOM 
	LEFT OUTER JOIN V_CUPOM_NAO_FISCAL_TP_CUPOM cn ON
	v.TP_CUPOM_NAO_FISCAL = cn.CD_TP_CUPOM_NAO_FISCAL
	LEFT OUTER JOIN PDV_CONSLD_VD_CUPOM_PENDENCIA P ON
	C.CD_EMP = P.CD_EMP AND
	C.CD_FILIAL = P.CD_FILIAL AND
	C.NR_ECF = P.NR_ECF AND
	C.CD_CX = P.CD_CX AND
	C.DT_VD = P.DT_VD AND
	C.TP_CUPOM = P.TP_CUPOM	
	LEFT OUTER JOIN ADM_ERRO_PDV_VD_INTEGRACOES e ON
	C.CD_EMP = e.CD_EMP AND
	C.CD_FILIAL = e.CD_FILIAL AND
	C.NR_ECF = e.NR_ECF AND
	C.CD_CX = e.CD_CX AND
	C.DT_VD = e.DT_VD AND
	C.TP_CUPOM = e.TP_CUPOM	
	LEFT OUTER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON 
	V.CD_EMP = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP AND
	V.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL AND
	V.CD_CTR = PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR 
	LEFT OUTER JOIN RC_DEB_PDV_VD_DEV_NCC NCC_RC_DEB ON
	PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = NCC_RC_DEB.CD_CTR_PGTO 
	LEFT OUTER JOIN RC_CREDIARIO_PARC_PDV_VD_DEV_NCC NCC_CRED_PARC ON
	PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = NCC_CRED_PARC.CD_CTR_PGTO 

WHERE
	C.TP_CUPOM = 1
